/*
*   Class  Chars
*
*   Methods for editing and examining a character
*
*   WRITTEN BY: Dr Michael Thomas Flanagan
*
*   DATE:       March 2013
*   REVISED:    25 January 2015, 12-14 June 2020
*
*   DOCUMENTATION:
*   See Michael Thomas Flanagan's Java library on-line web page:
*   http://www.ee.ucl.ac.uk/~mflanaga/java/Chars.html
*   http://www.ee.ucl.ac.uk/~mflanaga/java/
*
*   Copyright (c)2015 Michael Thomas Flanagan
*
*
***************************************************************************************/

package flanagan.util;

import java.util.HashSet;

public class Chars{
        
    private char enteredChar = '\u0000';                                         // Entered characte
    private char noAccentChar = '\u0000';                                        // character with any accent removed
    private int positionChar = 0;                                                // position in the alphabet, e.g A=1, a=1, B=2, b=2 etc
    private String htmlCode = null;                                              // html code
    private int asciiDecimal = 0;                                                // SCII decimal number
    private String asciiHexadec = null;                                          // ASCII hexadecimal number
    
    // Accent replacement arrays
    private char[] symbolsA = {'', '', '', '', '', '', '', '?', '?', '', '', '', '', '?', '', '', '', '', '', '', 
        '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '?', '?',        
        '', '', '', '', '?', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''};

    private char[] replSymbolsA = {'A', 'A', 'A', 'A', 'A', 'A', 'C', 'C','C', 'E', 'E', 'E', 'E',  'G','I', 'I', 'I', 'I', 'D', 'N', 'O', 'O', 'O', 'O', 'O', 'O', 'U', 'U', 'U', 'U', 'Y', 'a', 'a', 'a', 'a', 'a', 'a', 'c', 'e', 'e', 'e', 'e', 'g', 'i', 'i', 'i', 'i', 'd', 'n', 'o', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'u', 'y', 'y', 's', 's', 'y', 'f'};

    private int[] decNumbersA = {192, 193, 194, 195, 196, 197, 199, 262, 268, 200, 201, 202, 203, 286, 204, 205, 206, 207, 208, 209, 
        210, 211, 212, 213, 214, 216, 217, 218, 219, 220, 221, 224, 225, 226, 227, 228, 229, 231, 232, 233, 263, 269,
        234, 235, 287, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 248, 249, 250, 251, 252, 253, 255, 352, 353, 376, 402}; 
    
    private int nSymbolsA = symbolsA.length;
    
    
    // Quotation marks
    private int[] decNumbersQ = {34, 39, 130, 132, 139, 145, 146, 147, 148, 155, 171, 187};
    
    private int nSymbolsQ = decNumbersQ.length;
    
    // Dash numbers
    private int[] decNumbersD = {45, 150, 151, 8213, 8254, 8211, 8212};
    
    private int nSymbolsD = decNumbersD.length;
    
    // Calculate html hexadecimal number
    private String toHexadecimal(char cc){    
        int decimal = (int)cc;
        int remain;  
        String hexadec="";   
        char hexchars[]={'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};  
        while(decimal>0)  
        {  
            remain=decimal%16;   
            hexadec=hexchars[remain]+hexadec;   
            decimal=decimal/16;  
        }  
        return hexadec;  
    } 
    
    // Calculate html code
    private String toHtmlCode(char cc){
        int dec = (int)cc;
        String code = "&#"+dec+";";
        return code;
    }
    
    // Remove any accent
    private char toAccentless(char cc){
        char retwa = cc;
        for(int i=0; i<this.nSymbolsA; i++){
            if(retwa==this.symbolsA[i]){
                retwa = this.replSymbolsA[i];
                break;
            }
        }
        return retwa;
    }
    
    // Calculate position in the alphabet, e.g A=1, a=1, B=2, b=2 etc
    private int toPosition(char cc){
        int entN = (int)cc;
        int retN = '\u0000';
        boolean test = false;
        
        char lowUL = 'A';
        int lowUN = (int)lowUL;
        char highUL = 'Z';
        int highUN = (int)highUL;
        
        char lowLL = 'a';
        int lowLN = (int)lowLL;
        char highLL = 'z';
        int highLN = (int)highLL;
        
        if(entN>=lowUN && entN<=highUN){
            test = true;
            retN = entN - lowUN + 1;
        }
        else{
            if(!test){
                if(entN>=lowLN && entN<=highLN){
                    test = true;
                    retN = entN - lowLN + 1;
                }
            }
        }
        if(!test){
            retN = -1;
        }
        
        return retN; 
    }           
   
    // Constructors
    public Chars(){
    }
        
    public Chars(char cc){
        this.SetVariables(cc);
    }
    
    // Set variables
    private void SetVariables(char cc){
        this.enteredChar = cc;
        this.noAccentChar = this.toAccentless(cc);
        this.asciiDecimal = (int)cc;
        this.positionChar = this.toPosition(cc);
        this.asciiHexadec = this.toHexadecimal(cc);
        this.htmlCode = this.toHtmlCode(cc);
        
    }
  
    // Enter character as char
    public void setEntered(char cc){
        this.SetVariables(cc);
    }
    
    // Enter character as Character
    public void setEntered(Character cc){
        char ccc = (char)cc;
        this.SetVariables(ccc);
    }
  
    // Return entered character as char
    public char getEntered_as_char(){
        return this.enteredChar;
    }
    
     // Return entered character as Character
    public Character getEntered_as_Character(){
        return new Character(this.enteredChar);
    }
  
    // Removes all accents and replaces the accented letter with its non-accented equivalent 
    // instance method
    public char removeAccent(){
        return this.noAccentChar;
    }
    
    // Removes all accents and replaces the accented letter with its non-accented equivalent 
    // static method
    public static char removeAccent(char cc){
        Chars ccc = new Chars(cc);
        return ccc.removeAccent();
    }
    
    // Returns position of the letter in the alphabet, e.g. A = 1, B = 2, a = 1, b = 2 etc
    // instance method
    public int getPosition(){  
        char cc = this.enteredChar;
        int posn = this.toPosition(cc);

        if(posn<1){
            System.out.println("util/Chars/getPosition: argument is not alphabetic, 0 value returned");
            posn = 0;
        }      
        return posn;       
    }
    
     //static method
     public static int getPosition(char cc){  
            Chars ccc = new Chars(cc);
            return ccc.getPosition();
    }
    
    // Returns HTML code for the character
    // instance method
    public String getHTMLcode(){     
        return this.htmlCode;       
    }
    
    // static method
    public static String getHTMLcode(char cc){   
        Chars ccc = new Chars(cc);
        return ccc.getHTMLcode();
    }
    
    // Returns ASCII equivalent decimal number for the character
    // instance method
    public int getASCIIdec(){     
        return this.asciiDecimal;       
    }
    
    // static method
    public static int getASCIIdec(char cc){   
        Chars ccc = new Chars(cc);
        return ccc.getASCIIdec();
    }
    
    // Returns ASCII equivalent hexadecimal number for the character
    // instance method
    public String getASCIIhex(){     
        return this.asciiHexadec;       
    }
    
    // static method
    public static String getASCIIhex(char cc){   
        Chars ccc = new Chars(cc);
        return ccc.getASCIIhex();
    }
    
    // Converts to upper case
    // instance method
    public char toUpperCase(){
        char ccc = this.enteredChar;
        return Character.toUpperCase(ccc);
    }
    
    // Converts to upper case
    // static method
    public static char toUpperCase(char cc){
        return Character.toUpperCase(cc);
    }
   
    // Converts to lower case
    // instance method
    public char toLowerCase(){
        char ccc = this.enteredChar;
        return Character.toLowerCase(ccc);
    }
    
    // Converts to lower case
    // static method
    public static char toLowerCase(char cc){
        return Character.toLowerCase(cc);
    }
    

    // Returns true if character is alphabetic
    // instance method
    public boolean isAlphabetic(){  
        char ccc = this.enteredChar;
        boolean check = Character.isLetter(ccc);
        return check;
    }
    
    // static method
    public static boolean isAlphabetic(char cc){     
        boolean check = Character.isLetter(cc);
        return check;
    }
    
    // Returns true if character is a digit (0 to 9)
    // instance method
    public boolean isDigit(){    
        char ccc = this.enteredChar;
        boolean check = Character.isDigit(ccc);
        return check;
    }
    
        // static method
    public static boolean isDigit(char cc){     
        boolean check = Character.isDigit(cc);
        return check;
    }
    
    // Returns true if character is either alphabetic or a digit (0 to 9)
    // instance method
    public boolean isAlphanumeric(){  
        char ccc = this.enteredChar;
        boolean check = Character.isLetterOrDigit(ccc);
        return check;
    }
    
    // static method
    public static boolean isAlphanumeric(char cc){     
        boolean check = Character.isLetterOrDigit(cc);
        return check;
    }
    
            
    // Returns true if char is a quotation mark
    // instance method
    public boolean isQuotationMark(){
        boolean check = false;
        int chold = (int)this.enteredChar;
        for(int i=0; i<this.nSymbolsQ; i++){
            if(chold==this.decNumbersQ[i]){
                check = true;
                break;
            }
        }
        return check;
    } 
    
    // Returns true if char is a quotation mark
    // static method
    public static boolean isQuotationMark(char cc){
        Chars ccc = new Chars(cc);
        return ccc.isQuotationMark();
    }
              
    // Returns true if char is a dash
    // instance method
    public boolean isDash(){
        boolean check = false;
        int chold = (int)this.enteredChar;
        for(int i=0; i<this.nSymbolsD; i++){
            if(chold==this.decNumbersD[i]){
                check = true;
                break;
            }
        }
        return check;
    } 
    
    // Returns true if char is a quotation mark
    // static method
    public static boolean isDash(char cc){
        Chars ccc = new Chars(cc);
        return ccc.isDash();
    }
    
    // Returns true if char is a upper case
    // instance method
    public boolean isUpperCase(){
        char ccc = this.enteredChar;
        return Character.isUpperCase(ccc);
    } 
    
    // static method
    public static boolean isUpperCase(char cc){
        Chars ccc = new Chars(cc);
        return ccc.isUpperCase();
    }
    
    // Returns true if char is a lower case
    // instance method
    public boolean isLowerCase(){
        char ccc = this.enteredChar;
        return Character.isLowerCase(ccc);
    } 
    
    // static method
    public static boolean isLowerCase(char cc){
        Chars ccc = new Chars(cc);
        return ccc.isLowerCase();
    }
    
    
}