/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.ecuxplot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.nyet.ecuxplot.ECUxChartFactory;
import org.nyet.ecuxplot.ECUxChartPanel;
import org.nyet.ecuxplot.ECUxDataset;
import org.nyet.ecuxplot.ECUxPlot;
import org.nyet.ecuxplot.FATSDataset;

public class FATSChartFrame
extends ChartFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final FATSDataset dataset;
    private final ECUxPlot plotFrame;
    private final JTextField start;
    private final JTextField end;

    public static FATSChartFrame createFATSChartFrame(TreeMap<String, ECUxDataset> fileDatasets, ECUxPlot plotFrame) {
        FATSDataset dataset = new FATSDataset(fileDatasets);
        JFreeChart chart = ECUxChartFactory.createFATSChart(dataset);
        return new FATSChartFrame(chart, dataset, plotFrame);
    }

    public FATSChartFrame(JFreeChart chart, FATSDataset dataset, ECUxPlot plotFrame) {
        super("FATS Time", chart);
        this.dataset = dataset;
        this.plotFrame = plotFrame;
        CategoryPlot plot = chart.getCategoryPlot();
        plot.getRangeAxis().setLabel("seconds");
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator("{2}", (NumberFormat)new DecimalFormat("##.##")));
        renderer.setBaseItemLabelsVisible(true);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        ECUxChartPanel chartPanel = new ECUxChartPanel(chart);
        chartPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        panel.add((Component)((Object)chartPanel), "Center");
        JPanel rpmPanel = new JPanel();
        rpmPanel.setLayout(new BoxLayout(rpmPanel, 2));
        rpmPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.start = new JTextField("" + dataset.getStart(), 5);
        this.end = new JTextField("" + dataset.getEnd(), 5);
        rpmPanel.add(this.start);
        rpmPanel.add(new JLabel(" to "));
        rpmPanel.add(this.end);
        rpmPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        JButton apply = new JButton("Apply");
        apply.addActionListener(this);
        this.getRootPane().setDefaultButton(apply);
        rpmPanel.add(apply);
        rpmPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        JButton defaults = new JButton("Defaults");
        defaults.addActionListener(this);
        rpmPanel.add(defaults);
        panel.add((Component)rpmPanel, "Last");
        this.setContentPane(panel);
        this.setPreferredSize(this.windowSize());
        this.restoreLocation();
    }

    private void restoreLocation() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        Dimension s = this.windowSize();
        Point pl = this.plotFrame.getLocation();
        Point l = this.windowLocation();
        l.translate(pl.x, pl.y);
        if (l.x < 0) {
            l.x = 0;
        }
        if (l.y < 0) {
            l.y = 0;
        }
        if (l.x + s.width > d.width - s.width) {
            l.x = d.width - s.width;
        }
        if (l.y + s.height > d.height - s.width) {
            l.y = d.height - s.height;
        }
        super.setLocation(l);
    }

    public void setDatasets(TreeMap<String, ECUxDataset> fileDatasets) {
        this.dataset.clear();
        for (ECUxDataset data : fileDatasets.values()) {
            this.setDataset(data);
        }
    }

    public void setDataset(ECUxDataset data) {
        this.dataset.setValue(data);
    }

    public void clearDataset() {
        this.dataset.clear();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("Apply")) {
            this.dataset.setStart(Integer.valueOf(this.start.getText()));
            this.dataset.setEnd(Integer.valueOf(this.end.getText()));
        } else if (event.getActionCommand().equals("Defaults")) {
            this.dataset.setStart(4200);
            this.dataset.setEnd(6500);
        }
        this.getChartPanel().getChart().setTitle(this.dataset.getTitle());
    }

    private Dimension windowSize() {
        return new Dimension(ECUxPlot.getPreferences().getInt("FATSWindowWidth", 300), ECUxPlot.getPreferences().getInt("FATSWindowHeight", 400));
    }

    private void putWindowSize() {
        ECUxPlot.getPreferences().putInt("FATSWindowWidth", this.getWidth());
        ECUxPlot.getPreferences().putInt("FATSWindowHeight", this.getHeight());
    }

    private Point windowLocation() {
        return new Point(ECUxPlot.getPreferences().getInt("FATSWindowX", this.plotFrame.getWidth()), ECUxPlot.getPreferences().getInt("FATSWindowY", 0));
    }

    private void putWindowLocation() {
        Point l = this.getLocation();
        Point pl = this.plotFrame.getLocation();
        l.translate(-pl.x, -pl.y);
        ECUxPlot.getPreferences().putInt("FATSWindowX", l.x);
        ECUxPlot.getPreferences().putInt("FATSWindowY", l.y);
    }

    public void dispose() {
        this.putWindowSize();
        this.putWindowLocation();
        super.dispose();
    }

    public void saveChartAsPNG(File f) throws IOException {
        ChartUtilities.saveChartAsPNG((File)f, (JFreeChart)this.getChartPanel().getChart(), (int)this.getWidth(), (int)this.getHeight());
    }

    public void saveChartAsPNG(String filename) throws IOException {
        this.saveChartAsPNG(new File(filename));
    }
}

