/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.ecuxplot;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.nyet.util.Files;

public class Loggers {
    public static final String[] pedalnames = new String[]{"AcceleratorPedalPosition", "AccelPedalPosition", "Zeitronix TPS", "Accelerator position", "Pedal Position"};
    public static final String[] throttlenames = new String[]{"ThrottlePlateAngle", "Throttle Angle", "Throttle Valve Angle", "TPS"};
    public static final String[] gearnames = new String[]{"Gear", "SelectedGear", "Engaged Gear"};
    private static final String[][] VCDS_aliases = new String[][]{{"^Zeit$", "TIME"}, {"^Boost Pressure \\(actual\\)$", "BoostPressureActual"}, {"^Boost Pressure \\(specified\\)$", "BoostPressureDesired"}, {"^(Engine RPM|Engine [Ss]peed|Motordrehzahl).*", "RPM"}, {"^Idle (RPM|[Ss]peed).*", "Idle RPM"}, {"^Throttle [Aa]ngle.*", "ThrottleAngle"}, {"^Throttle [Vv]alve [Aa]ngle.*", "ThrottleAngle"}, {"^Mass [Aa]ir [Ff]low.*", "MassAirFlow"}, {"^Mass [Aa]ir [Tt]aken [Ii]n.*", "MassAirFlow"}, {"^Mass Flow$", "MassAirFlow"}, {"^Ign timing.*", "IgnitionTimingAngle"}};
    private static final String[][] Zeitronix_aliases = new String[][]{{".*RPM$", "RPM"}, {".*Boost$", "Boost"}, {".*TPS$", "TPS"}, {".*AFR$", "AFR"}, {".*Lambda$", "Lambda"}, {".*EGT$", "EGT"}};
    private static final String[][] ECUX_aliases = new String[][]{{"^BstActual$", "BoostPressureActual"}, {"^BstDesired$", "BoostPressureDesired"}};
    private static final String[][] EVOSCAN_aliases = new String[][]{{".*RPM$", "RPM"}, {"^LogEntrySeconds$", "TIME"}, {"^TPS$", "ThrottlePlateAngle"}, {"^APP$", "AccelPedalPosition"}, {"^IAT$", "IntakeAirTemperature"}};
    private static final String[][] ME7L_aliases = new String[][]{{"^Engine[Ss]peed$", "RPM"}, {"^BoostPressureSpecified$", "BoostPressureDesired"}, {"^EngineLoadCorrectedSpecified$", "EngineLoadCorrected"}, {"^AtmosphericPressure$", "BaroPressure"}, {"^AirFuelRatioRequired$", "AirFuelRatioDesired"}, {"^InjectionTime$", "EffInjectionTime"}, {"^InjectionTimeBank2$", "EffInjectionTimeBank2"}};
    private static final String[][] VOLVOLOGGER_aliases = new String[][]{{"^Time$", "TIME"}, {"^Engine [Ss]peed$", "RPM"}, {"^(Actual )?Boost Pressure$", "BoostPressureActual"}, {"^Desired Boost Pressure$", "BoostPressureDesired"}, {"^Mass Air Flow$", "MAF"}};
    private static final String[][] LOGWORKS_aliases = new String[][]{{"^time$", "TIME"}, {"^Boost$", "BoostPressureActual"}, {"^LC1_O2WB$", "AFR"}};
    private static final String[][] JB4_aliases = new String[][]{{"^timestamp$", "TIME"}, {"^rpm$", "RPM"}, {"^pedal$", "AccelPedalPosition (%)"}, {"^mph$", "VehicleSpeed (mph)"}, {"^throttle$", "ThrottlePlateAngle (%)"}, {"^ecu_psi$", "ECUBoostPressureActual (PSI)"}, {"^dme_bt$", "ECUBoostPressureDesired (PSI)"}, {"^target$", "BoostPressureDesiredDelta (PSI)"}, {"^boost$", "BoostPressureActual (PSI)"}, {"^boost2$", "BoostPressureActual2 (PSI)"}, {"^ff$", "BoostFeedForward"}, {"^map$", "SelectedMap"}, {"^wgdc$", "WastegateDutyCycle (%)"}, {"^iat$", "IntakeAirTemperature (\u00b0F)"}, {"^fp_h$", "FuelPressureHigh (PSI)"}, {"^fp_l$", "FuelPressureLow (PSI)"}, {"^waterf$", "WaterTemperature (\u00b0F)"}, {"^oilf$", "OilTemperature (\u00b0F)"}, {"^transf$", "TransmissionTemperature (\u00b0F)"}, {"^gear$", "Gear"}, {"^load$", "EngineLoad (%)"}, {"^calc_torque$", "CalculatedTorque"}, {"^afr$", "AirFuelRatio (AFR)"}, {"^afr2$", "AirFuelRatio2 (AFR)"}, {"^trims$", "FuelTrim (%)"}, {"^trims2$", "FuelTrim2 (%)"}, {"^fuelen$", "FuelEnrichment (%)"}, {"^meth$", "MethanolFlow (%)"}, {"^e85$", "E85"}, {"^avg_ign$", "AverageIgnitionRetard"}, {"^ign_1$", "IgnitionTimingAngle1"}, {"^ign_2$", "IgnitionTimingAngle2"}, {"^ign_3$", "IgnitionTimingAngle3"}, {"^ign_4$", "IgnitionTimingAngle4"}, {"^ign_5$", "IgnitionTimingAngle5"}, {"^ign_6$", "IgnitionTimingAngle6"}, {"^ign_7$", "IgnitionTimingAngle7"}, {"^ign_6$", "IgnitionTimingAngle8"}};
    private static final String[][] COBB_AP_aliases = new String[][]{{"^AP Info:.*", ""}, {"^Time", "TIME"}, {"^Engine Speed", "RPM"}, {"^Current Gear", "Gear"}, {"^Accel Pedal Position", "AccelPedalPosition"}, {"^TPS", "ThrottlePlateAngle"}, {"^AFR", "AirFuelRatio"}, {"^AFR Set Point", "AirFuelRatioDesired"}, {"^Trgt\\. Boost Press\\.", "BoostPressureDesired"}, {"^Boost Press\\.", "BoostPressureActual"}, {"^Ambient Air Temp\\.", "AmbientTemperature (\u00b0F)"}, {"^Coolant Temp\\.", "WaterTemperature (\u00b0F)"}, {"^Engine Oil Temp\\.", "OilTemperature (\u00b0F)"}, {"^IAT", "IntakeAirTemperature (\u00b0F)"}, {"^Ignition Timing Final", "IgnitionTimingAngle"}, {"^Knock Retard Cylinder 1", "IgnitionRetardCyl1"}, {"^Knock Retard Cylinder 2", "IgnitionRetardCyl2"}, {"^Knock Retard Cylinder 3", "IgnitionRetardCyl3"}, {"^Knock Retard Cylinder 4", "IgnitionRetardCyl4"}, {"^Knock Retard Cylinder 5", "IgnitionRetardCyl5"}, {"^Knock Retard Cylinder 6", "IgnitionRetardCyl6"}, {"^Knock Retard Cylinder 7", "IgnitionRetardCyl7"}, {"^Knock Retard Cylinder 8", "IgnitionRetardCyl8"}, {"^Turbine Act. Base Value", "WastegateDutyCycleBase"}, {"^Turbine Act. Final Value", "WastegateDutyCycle"}, {"^Vehicle Speed", "VehicleSpeed"}};
    private static final String[][] DEFAULT_aliases = new String[][]{{"^[Tt]ime$", "TIME"}, {"^[Ee]ngine [Ss]peed$", "RPM"}, {"^[Mm]ass air flow$", "MassAirFlow"}, {"^Engine Speed$", "RPM"}, {"^Target Position Throttle$", "ThrottlePlateAngle"}, {"^Manifold Absolute Pressure$", "BoostPressureActual"}, {"^Manifold Pressure$", "BoostPressureActual"}, {"^Intake air temperature$", "IntakeAirTemperature"}, {"^Lambda Bank 1$", "AirFuelRatioCurrent"}, {"^Lambda Bank 2$", "AirFuelRatioCurrentBank2"}, {"^Ignition Angle Actual$", "IgnitionTimingAngleOverall"}, {"^Relative Load$", "EngineLoad"}, {"^Actual Ignition Angle$", "IgnitionTimingAngleOverall"}, {"^Vehicle Speed$", "VehicleSpeed"}};
    private static final Map<LoggerType, String[][]> Aliases = new HashMap<LoggerType, String[][]>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(LoggerType.LOG_ECUX, ECUX_aliases);
            this.put(LoggerType.LOG_ECUX, ECUX_aliases);
            this.put(LoggerType.LOG_VCDS, VCDS_aliases);
            this.put(LoggerType.LOG_ZEITRONIX, Zeitronix_aliases);
            this.put(LoggerType.LOG_ME7LOGGER, ME7L_aliases);
            this.put(LoggerType.LOG_EVOSCAN, EVOSCAN_aliases);
            this.put(LoggerType.LOG_VOLVOLOGGER, VOLVOLOGGER_aliases);
            this.put(LoggerType.LOG_LOGWORKS, LOGWORKS_aliases);
            this.put(LoggerType.LOG_JB4, JB4_aliases);
            this.put(LoggerType.LOG_COBB_AP, COBB_AP_aliases);
        }
    };

    private static String[][] which(LoggerType logger) {
        if (Aliases.containsKey((Object)logger)) {
            return Aliases.get((Object)logger);
        }
        return DEFAULT_aliases;
    }

    public static void processAliases(String[] h, LoggerType logger) {
        Loggers.processAliases(h, Loggers.which(logger));
    }

    public static void processAliases(String[] h) {
        Loggers.processAliases(h, DEFAULT_aliases);
    }

    public static void processAliases(String[] h, String[][] a) {
        for (int i = 0; i < h.length; ++i) {
            h[i] = h[i].trim();
            for (String[] s : a) {
                if (!h[i].matches(s[0]) || ArrayUtils.contains((Object[])h, (Object)s[1])) continue;
                h[i] = s[1];
            }
            if (i <= 0 || h[i].length() <= 0) continue;
            Object[] prev = Arrays.copyOfRange(h, 0, i);
            Object renamed = h[i];
            boolean rename = false;
            int j = 2;
            while (ArrayUtils.contains((Object[])prev, (Object)renamed)) {
                renamed = h[i] + " " + Integer.toString(j);
                rename = true;
                ++j;
            }
            if (!rename) continue;
            h[i] = renamed;
        }
    }

    public static DetectResult detect(String[] h) {
        for (int i = 0; i < h.length; ++i) {
            h[i] = h[i].trim();
            if (h[i].matches("^VCDS.*")) {
                return new DetectResult(LoggerType.LOG_VCDS, h[i]);
            }
            if (!h[i].matches("^AP Info:.*")) continue;
            return new DetectResult(LoggerType.LOG_COBB_AP, h[i]);
        }
        LoggerType t = Loggers.detect(h[0]);
        if (t == LoggerType.LOG_UNKNOWN) {
            return new DetectResult(t);
        }
        return new DetectResult(t, h[0]);
    }

    public static LoggerType detect(String h) {
        if (h.matches("^.*(day|tag)$")) {
            return LoggerType.LOG_VCDS;
        }
        if (h.matches("^Filename:.*") && (Files.extension(h).equals("zto") || Files.extension(h).equals("zdl") || h.matches(".*<unnamed file>$"))) {
            return LoggerType.LOG_ZEITRONIX;
        }
        if (h.matches("^TIME$")) {
            return LoggerType.LOG_ECUX;
        }
        if (h.matches(".*ME7-Logger.*")) {
            return LoggerType.LOG_ME7LOGGER;
        }
        if (h.matches("^LogID$")) {
            return LoggerType.LOG_EVOSCAN;
        }
        if (h.matches("^Time\\s*\\(sec\\)$")) {
            return LoggerType.LOG_VOLVOLOGGER;
        }
        if (h.matches("^Session: Session [0-8]+$")) {
            return LoggerType.LOG_LOGWORKS;
        }
        if (h.matches("^Firmware$")) {
            return LoggerType.LOG_JB4;
        }
        return LoggerType.LOG_UNKNOWN;
    }

    public static enum LoggerType {
        LOG_UNKNOWN,
        LOG_ERR,
        LOG_DETECT,
        LOG_ECUX,
        LOG_VCDS,
        LOG_ZEITRONIX,
        LOG_ME7LOGGER,
        LOG_EVOSCAN,
        LOG_VOLVOLOGGER,
        LOG_LOGWORKS,
        LOG_JB4,
        LOG_COBB_AP;

    }

    public static class DetectResult {
        LoggerType type;
        String message;

        public DetectResult(LoggerType type, String message) {
            this.type = type;
            this.message = message;
        }

        public DetectResult(LoggerType type) {
            this.type = type;
            this.message = "";
        }
    }
}

