/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.ecuxplot;

import java.util.prefs.Preferences;

public class SAE {
    public static final String PREFS_TAG = "SAE";
    private static final boolean defaultEnabled = false;
    private static final double defaultTemperature = 25.0;
    private static final double defaultAltitude = 196.0;
    private static final double defaultHumidity = 0.0;
    private final Preferences prefs;

    public SAE(Preferences prefs) {
        this.prefs = prefs.node(PREFS_TAG);
    }

    public static boolean enabled(Preferences prefs) {
        return prefs.node(PREFS_TAG).getBoolean("enabled", false);
    }

    public boolean enabled() {
        return this.prefs.getBoolean("enabled", false);
    }

    public void enabled(boolean val) {
        this.prefs.putBoolean("enabled", val);
    }

    public double temperature() {
        return this.prefs.getDouble("temperature", 25.0);
    }

    public void temperature(double val) {
        this.prefs.putDouble("temperature", val);
    }

    public double altitude() {
        return this.prefs.getDouble("altitude", 196.0);
    }

    public void altitude(double val) {
        this.prefs.putDouble("altitude", val);
    }

    public double humidity() {
        return this.prefs.getDouble("humidity", 0.0);
    }

    public void humidity(double val) {
        this.prefs.putDouble("humidity", val);
    }

    private double vaporpressure() {
        return 6.1078 * Math.pow(10.0, 7.5 * this.temperature() / (237.3 + this.temperature()));
    }

    private double drypressure() {
        double p0 = 1013.25;
        double T0 = 288.15;
        double g = 9.80665;
        double L = 0.0065;
        double R = 8.31432;
        double M = 0.0289644;
        return 1013.25 * Math.pow(1.0 - 0.0065 * this.altitude() / 288.15, 5.255876113278518);
    }

    public double correction() {
        double Pv = this.humidity() / 100.0 * this.vaporpressure();
        double Pd = this.drypressure() - Pv;
        return 1.18 * (990.0 / Pd * Math.pow((this.temperature() + 273.0) / 298.0, 0.5)) - 0.18;
    }
}

