/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.matrix;

import ru.sscc.matrix.RealMatrix;
import ru.sscc.matrix.SymBandedMatrix;
import ru.sscc.util.data.DoubleContainer;
import ru.sscc.util.data.RealContainer;
import ru.sscc.util.data.RealMath;
import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.RealVector;

public class RectBandedMatrix
extends RealMatrix {
    private boolean toeplitz;
    public final int bandWidth;

    public RectBandedMatrix(int n, int n2, boolean bl) {
        this(new DoubleContainer(bl ? n2 : n * n2), n, n2, bl);
    }

    public RectBandedMatrix(RealContainer realContainer, int n, int n2, boolean bl) {
        super(realContainer, n, n + n2 - 1);
        realContainer.ensureSize(bl ? n2 : n * n2);
        this.bandWidth = n2;
        this.toeplitz = bl;
    }

    public double add(int n, int n2, double d) {
        if ((n2 -= n) < 0 || n2 >= this.bandWidth) {
            throw new IllegalArgumentException("Cannot set a value of the matrix entry");
        }
        return this.entries.add(this.toeplitz ? n2 : n * this.bandWidth + n2, d);
    }

    public void compose(double d, double d2, SymBandedMatrix symBandedMatrix, RealVector realVector, SymBandedMatrix symBandedMatrix2) {
        this.ensureAlgebraic();
        symBandedMatrix.ensureAlgebraic();
        symBandedMatrix2.ensureAlgebraic();
        if (this.nRows != symBandedMatrix.nRows || this.nRows != symBandedMatrix2.nRows || symBandedMatrix2.halfWidth < symBandedMatrix.halfWidth || symBandedMatrix2.halfWidth < this.bandWidth) {
            throw new IllegalArgumentException("Can't compose incompatible matrices");
        }
        if (realVector != null || !this.toeplitz || !symBandedMatrix.isToeplitz()) {
            symBandedMatrix2.expand();
        }
        if (this.nRows != 0) {
            if (realVector != null) {
                this.doCompose(d, d2, symBandedMatrix, realVector, symBandedMatrix2);
            } else if (this.toeplitz) {
                this.doComposeT(d, d2, symBandedMatrix, symBandedMatrix2);
            } else {
                this.doCompose(d, d2, symBandedMatrix, symBandedMatrix2);
            }
        }
    }

    private void doCompose(double d, double d2, SymBandedMatrix symBandedMatrix, SymBandedMatrix symBandedMatrix2) {
        int n = symBandedMatrix2.nRows;
        int n2 = symBandedMatrix.halfWidth;
        int n3 = symBandedMatrix2.halfWidth;
        int n4 = symBandedMatrix.isToeplitz() ? 0 : n2;
        int n5 = this.toeplitz ? 0 : this.bandWidth;
        RealPointer realPointer = symBandedMatrix.getContainer().getPointer();
        RealPointer realPointer2 = symBandedMatrix2.getContainer().getPointer();
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n) {
            realPointer.reset(n7, 1);
            realPointer2.reset(n6, 1);
            int n10 = Math.min(n3, n - n9);
            int n11 = 0;
            int n12 = n8;
            while (n11 < n10) {
                double d3 = this.entries.postProduct(n8 + n11, 1, n12, 1, this.bandWidth - n11) * d2;
                if (n11 < n2) {
                    d3 += realPointer.get() * d;
                    realPointer.next();
                }
                realPointer2.set(d3);
                ++n11;
                n12 += n5;
                realPointer2.next();
            }
            ++n9;
            n8 += n5;
            n7 += n4;
            n6 += n3;
        }
    }

    private void doCompose(double d, double d2, SymBandedMatrix symBandedMatrix, RealVector realVector, SymBandedMatrix symBandedMatrix2) {
        int n = symBandedMatrix2.nRows;
        int n2 = symBandedMatrix.halfWidth;
        int n3 = symBandedMatrix2.halfWidth;
        int n4 = symBandedMatrix.isToeplitz() ? 0 : n2;
        int n5 = this.toeplitz ? 0 : this.bandWidth;
        RealPointer realPointer = symBandedMatrix.getContainer().getPointer();
        RealPointer realPointer2 = symBandedMatrix2.getContainer().getPointer();
        RealPointer realPointer3 = realVector.getPointer();
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n) {
            realPointer.reset(n7, 1);
            realPointer2.reset(n6, 1);
            int n10 = Math.min(n3, n - n9);
            int n11 = 0;
            int n12 = n8;
            while (n11 < n10) {
                double d3 = this.entries.weightedProduct(n8 + n11, 1, n12, 1, realPointer3, this.bandWidth - n11) * d2;
                if (n11 < n2) {
                    d3 += realPointer.get() * d;
                    realPointer.next();
                }
                realPointer2.set(d3);
                ++n11;
                n12 += n5;
                realPointer2.next();
                realPointer3.next();
            }
            realPointer3.shift(1 - n10);
            ++n9;
            n8 += n5;
            n7 += n4;
            n6 += n3;
        }
    }

    private void doComposeT(double d, double d2, SymBandedMatrix symBandedMatrix, SymBandedMatrix symBandedMatrix2) {
        int n = symBandedMatrix2.nRows;
        int n2 = symBandedMatrix.halfWidth;
        int n3 = symBandedMatrix2.halfWidth;
        int n4 = symBandedMatrix.isToeplitz() ? 0 : n2;
        int n5 = symBandedMatrix2.isToeplitz() ? 0 : n3;
        RealPointer realPointer = symBandedMatrix.getContainer().getPointer();
        RealPointer realPointer2 = symBandedMatrix2.getContainer().getPointer();
        int n6 = 0;
        while (n6 < n3) {
            double d3 = this.entries.postProduct(0, 1, n6, 1, this.bandWidth - n6) * d2;
            if (n4 == 0) {
                d3 += n6 < n2 ? realPointer.get() * d : 0.0;
                realPointer.next();
                if (n5 == 0) {
                    realPointer2.set(d3);
                    realPointer2.next();
                } else {
                    RealMath.assign(realPointer2.reset(n6, n5), d3, n - n6);
                }
            } else {
                int n7 = 0;
                realPointer.reset(n6, n4);
                realPointer2.reset(n6, n5);
                while (n7 < n - n6) {
                    realPointer2.set(d3 + (n6 < n2 ? realPointer.get() * d : 0.0));
                    ++n7;
                    realPointer.next();
                    realPointer2.next();
                }
            }
            ++n6;
        }
    }

    public double get(int n, int n2) {
        return (n2 -= n) >= 0 && n2 < this.bandWidth ? this.entries.get(this.toeplitz ? n2 : n * this.bandWidth + n2) : 0.0;
    }

    public final boolean isToeplitz() {
        return this.toeplitz;
    }

    public double mul(int n, int n2, double d) {
        if ((n2 -= n) < 0 || n2 >= this.bandWidth) {
            throw new IllegalArgumentException("Cannot set a value of the matrix entry");
        }
        return this.entries.mul(this.toeplitz ? n2 : n * this.bandWidth + n2, d);
    }

    public void multiply(RealVector realVector, RealVector realVector2) {
        this.ensureAlgebraic();
        if (this.nRows == 0) {
            return;
        }
        realVector.ensureLength(this.nColumns);
        realVector2.ensureLength(this.nRows);
        RealPointer realPointer = realVector.getPointer();
        RealPointer realPointer2 = realVector2.getPointer();
        int n = this.toeplitz ? 0 : this.bandWidth;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.nRows) {
            realPointer2.set(this.entries.postProduct(n2, 1, realPointer, this.bandWidth));
            ++n3;
            n2 += n;
            realPointer2.next();
            realPointer.next();
        }
    }

    public void multiplyT(RealVector realVector, RealVector realVector2) {
        this.ensureAlgebraic();
        if (this.nRows == 0) {
            return;
        }
        realVector.ensureLength(this.nRows);
        realVector2.ensureLength(this.nColumns);
        RealPointer realPointer = realVector.getPointer(0, -1);
        RealPointer realPointer2 = realVector2.getPointer();
        int n = this.toeplitz ? 0 : this.bandWidth;
        int n2 = Math.min(this.bandWidth, this.nRows);
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.nColumns) {
            realPointer2.set(this.entries.postProduct(n3, 1 - n, realPointer, Math.min(n4 + 1, n2)));
            if (++n4 < this.nRows) {
                n3 += n;
                realPointer.previous();
            } else {
                ++n3;
                n2 = Math.min(n2, this.nColumns - n4);
            }
            realPointer2.next();
        }
    }

    public void reuse() {
        this.unlock();
    }

    public double set(int n, int n2, double d) {
        if ((n2 -= n) < 0 || n2 >= this.bandWidth) {
            throw new IllegalArgumentException("Cannot set a value of the matrix entry");
        }
        return this.entries.set(this.toeplitz ? n2 : n * this.bandWidth + n2, d);
    }
}

