/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.ecuxplot;

import java.util.prefs.Preferences;

public class Fueling {
    public static final String PREFS_TAG = "fueling";
    private static final double defaultMAF = 73.0;
    private static final double defaultInjector = 349.0;
    private static final double defaultMAF_offset = 6.0;
    private static final int defaultCylinders = 6;
    private static final int defaultTurbos = 2;
    private final Preferences prefs;

    public Fueling(Preferences prefs) {
        this.prefs = prefs.node(PREFS_TAG);
    }

    public double MAF() {
        return this.prefs.getDouble("MAF", 73.0);
    }

    public void MAF(double val) {
        this.prefs.putDouble("MAF", val);
    }

    public double MAF_correction() {
        double maf = this.MAF();
        return maf * maf / 5329.0;
    }

    public double injector() {
        return this.prefs.getDouble("injector", 349.0);
    }

    public void injector(double val) {
        this.prefs.putDouble("injector", val);
    }

    public double MAF_offset() {
        return this.prefs.getDouble("MAF_offset", 6.0);
    }

    public void MAF_offset(double val) {
        this.prefs.putDouble("MAF_offset", val);
    }

    public int cylinders() {
        return this.prefs.getInt("cylinders", 6);
    }

    public void cylinders(int val) {
        this.prefs.putInt("cylinders", val);
    }

    public int turbos() {
        return this.prefs.getInt("turbos", 2);
    }

    public void turbos(int val) {
        this.prefs.putInt("turbos", val);
    }

    public Preferences get() {
        return this.prefs;
    }
}

