/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.ecuxplot;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import org.nyet.ecuxplot.ECUxPlot;
import org.nyet.ecuxplot.ECUxPreset;
import org.nyet.ecuxplot.Filter;
import org.nyet.ecuxplot.SAE;

public final class OptionsMenu
extends JMenu {
    private static final long serialVersionUID = 1L;
    private final ECUxPlot plotFrame;
    private final JMenu loadPresetsMenu;
    private final JMenu savePresetsMenu;
    private final JMenu deletePresetsMenu;
    private JCheckBox fatsCheckBox;
    private JCheckBox scatterCheckBox;
    private JCheckBox filterCheckBox;

    public OptionsMenu(String id, ECUxPlot plotFrame) {
        super(id);
        this.plotFrame = plotFrame;
        this.loadPresetsMenu = new JMenu("Load Preset...");
        this.savePresetsMenu = new JMenu("Save Preset...");
        JMenuItem jmi = new JMenuItem("Load All Presets");
        jmi.addActionListener(new LoadAllPresetsAction());
        this.add(jmi);
        this.deletePresetsMenu = new JMenu("Delete Preset...");
        this.updatePresets();
        this.add(this.loadPresetsMenu);
        this.add(jmi);
        this.add(this.savePresetsMenu);
        this.add(this.deletePresetsMenu);
        this.add(new JSeparator());
        Preferences prefs = ECUxPlot.getPreferences();
        JCheckBox jcb = new JCheckBox("Use alternate column names", prefs.getBoolean("altnames", false));
        jcb.addActionListener(plotFrame);
        this.add(jcb);
        jcb = new JCheckBox("Scatter plot", ECUxPlot.scatter(prefs));
        jcb.addActionListener(plotFrame);
        this.add(jcb);
        this.scatterCheckBox = jcb;
        this.add(new JSeparator());
        jcb = new JCheckBox("Filter data", Filter.enabled(prefs));
        jcb.addActionListener(plotFrame);
        this.add(jcb);
        this.filterCheckBox = jcb;
        jcb = new JCheckBox("Show all ranges", Filter.showAllRanges(prefs));
        jcb.addActionListener(plotFrame);
        this.add(jcb);
        jmi = new JMenuItem("Next range...");
        jmi.addActionListener(plotFrame);
        this.add(jmi);
        jmi = new JMenuItem("Previous range...");
        jmi.addActionListener(plotFrame);
        this.add(jmi);
        this.add(new JSeparator());
        jcb = new JCheckBox("Apply SAE", SAE.enabled(prefs));
        jcb.addActionListener(plotFrame);
        this.add(jcb);
        jcb = new JCheckBox("Show FATS window...", prefs.getBoolean("showfats", false));
        jcb.addActionListener(plotFrame);
        this.add(jcb);
        this.fatsCheckBox = jcb;
        this.add(new JSeparator());
        jmi = new JMenuItem("Configure filter...");
        jmi.addActionListener(plotFrame);
        this.add(jmi);
        jmi = new JMenuItem("Edit SAE constants...");
        jmi.addActionListener(plotFrame);
        this.add(jmi);
        jmi = new JMenuItem("Edit PID...");
        jmi.addActionListener(plotFrame);
        this.add(jmi);
        this.add(new JSeparator());
        jmi = new JMenuItem("Show Debug Logs...");
        jmi.addActionListener(plotFrame);
        this.add(jmi);
        jmi = new JMenuItem("Show Filter Debug Panel...");
        jmi.addActionListener(plotFrame);
        this.add(jmi);
    }

    private void updatePresets() {
        JMenuItem jmi;
        this.loadPresetsMenu.removeAll();
        this.savePresetsMenu.removeAll();
        this.deletePresetsMenu.removeAll();
        LoadPresetAction lpa = new LoadPresetAction();
        SavePresetAction spa = new SavePresetAction();
        DeletePresetAction dpa = new DeletePresetAction();
        Boolean undoPresent = false;
        Boolean addSeparator = false;
        for (String s : ECUxPreset.getPresets()) {
            if (!s.equals("Undo")) {
                jmi = new JMenuItem(s);
                jmi.addActionListener(lpa);
                this.loadPresetsMenu.add(jmi);
                jmi = new JMenuItem(s);
                this.savePresetsMenu.add(jmi);
                jmi.addActionListener(spa);
                jmi = new JMenuItem(s);
                this.deletePresetsMenu.add(jmi);
                jmi.addActionListener(dpa);
            } else {
                undoPresent = true;
            }
            addSeparator = true;
        }
        if (undoPresent.booleanValue()) {
            if (addSeparator.booleanValue()) {
                this.loadPresetsMenu.add(new JSeparator());
            }
            jmi = new JMenuItem("Undo");
            jmi.addActionListener(lpa);
            this.loadPresetsMenu.add(jmi);
        }
        if (addSeparator.booleanValue()) {
            this.savePresetsMenu.add(new JSeparator());
        }
        jmi = new JMenuItem("New Preset...");
        jmi.addActionListener(spa);
        this.savePresetsMenu.add(jmi);
        this.savePresetsMenu.add(new JSeparator());
        jmi = new JMenuItem("Restore Defaults");
        jmi.addActionListener(spa);
        this.savePresetsMenu.add(jmi);
    }

    public void updateFATSCheckbox() {
        if (this.fatsCheckBox != null) {
            Preferences prefs = ECUxPlot.getPreferences();
            this.fatsCheckBox.setSelected(prefs.getBoolean("showfats", false));
        }
    }

    public void updateScatterCheckbox() {
        if (this.scatterCheckBox != null) {
            Preferences prefs = ECUxPlot.getPreferences();
            this.scatterCheckBox.setSelected(ECUxPlot.scatter(prefs));
        }
    }

    public void updateFilterCheckbox() {
        if (this.filterCheckBox != null) {
            Preferences prefs = ECUxPlot.getPreferences();
            this.filterCheckBox.setSelected(Filter.enabled(prefs));
        }
    }

    private class LoadAllPresetsAction
    implements ActionListener {
        private LoadAllPresetsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(ECUxPreset.getPresets()));
            list.remove("Undo");
            OptionsMenu.this.plotFrame.loadPresets(list);
        }
    }

    private class LoadPresetAction
    implements ActionListener {
        private LoadPresetAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String s = event.getActionCommand();
            if (!s.equals("Undo")) {
                OptionsMenu.this.plotFrame.saveUndoPreset();
                OptionsMenu.this.updatePresets();
            }
            OptionsMenu.this.plotFrame.loadPreset((Comparable<String>)((Object)s));
        }
    }

    private class SavePresetAction
    implements ActionListener {
        private final List<String> blacklist = Arrays.asList("Undo", "New Preset...", "Restore Defaults", "");

        private SavePresetAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String s = event.getActionCommand();
            if (s.equals("Restore Defaults")) {
                ECUxPreset.createDefaultECUxPresets();
            } else {
                if (s.equals("New Preset...")) {
                    s = ECUxPlot.showInputDialog("Enter preset name");
                    if (s == null) {
                        return;
                    }
                    if (this.blacklist.contains(s)) {
                        JOptionPane.showMessageDialog(null, "Illegal name");
                        return;
                    }
                    for (String k : ECUxPreset.getPresets()) {
                        if (!s.equals(k)) continue;
                        JOptionPane.showMessageDialog(null, "Name in use");
                        return;
                    }
                }
                OptionsMenu.this.plotFrame.savePreset((Comparable<?>)((Object)s));
            }
            OptionsMenu.this.updatePresets();
        }
    }

    private class DeletePresetAction
    implements ActionListener {
        private DeletePresetAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String s = event.getActionCommand();
            try {
                ECUxPreset.getPreferencesStatic().node(s).removeNode();
                OptionsMenu.this.updatePresets();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

