/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.ecuxplot;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Units {
    private static final Logger logger = LoggerFactory.getLogger(Units.class);

    public static final String find(String id) {
        String[][] legend;
        if (id == null) {
            return null;
        }
        for (String[] element : legend = new String[][]{{"AcceleratorPedalPosition", "%"}, {"AirFuelRatioDesired", "lambda"}, {"EGTbank1", "\u00b0F"}, {"EGTbank1OXS", "\u00b0C"}, {"EGTbank2", "\u00b0F"}, {"EGTbank2OXS", "\u00b0C"}, {"FuelInjectorOnTime", "ms"}, {"FuelInjectorDutyCycle", "%"}, {"IntakeAirTemperature", "\u00b0C"}, {"MassAirFlow", "g/sec"}, {"ThrottlePlateAngle", "%"}, {"VehicleSpeed", "kph"}, {"TPS", "%"}, {"RPM", "RPM"}, {"TIME", "s"}, {"Time", "s"}, {"Zeitronix TPS", "%"}, {"Zeitronix Time", "s"}, {"KnockVolt.*", "V"}, {"OXSVolt.*", "V"}, {".*BoostPressure.*", "mBar"}, {".*DutyCycle.*", "%"}, {".*Angle.*", "\u00b0"}, {".*Ignition.*Retard.*", "\u00b0"}, {".*Ignition.*Timing.*", "\u00b0"}, {".*Load.*", "%"}, {".*Pressure.*", "mBar"}, {".*Voltage.*", "V"}, {".*AFR.*", "AFR"}, {".*AirFuelRatio.*", "AFR"}, {".*[Ll]ambda.*", "lambda"}}) {
            if (!id.matches(element[0])) continue;
            return element[1];
        }
        return "";
    }

    public static final String normalize(String u) {
        String[][] map;
        if (u == null) {
            return "";
        }
        for (String[] element : map = new String[][]{{"^1/min$", "RPM"}, {"\u00b0KW", "\u00b0"}, {"^DK$", "\u00b0"}, {"^[Dd]egrees$", "\u00b0"}, {"^PED$", "\u00b0"}, {"^C$", "\u00b0C"}, {"^F$", "\u00b0F"}, {"^mbar$", "mBar"}, {"^psi$", "PSI"}, {"^PSI/.*", "PSI"}, {"^rpm", "RPM"}, {"^-$", ""}}) {
            if (!u.trim().matches(element[0])) continue;
            return element[1];
        }
        return u.trim();
    }

    public static final String[] processUnits(String[] h, String[] u) {
        if (u.length < h.length) {
            u = Arrays.copyOf(u, h.length);
        }
        for (int i = 0; i < h.length; ++i) {
            u[i] = Units.normalize(u[i]);
            if (h[i].length() <= 0 || u[i] != null && u[i].length() != 0) continue;
            u[i] = Units.find(h[i]);
            if (u[i] != null && u[i].length() != 0) continue;
            logger.warn("Can't find units for '{}'", (Object)h[i]);
        }
        return u;
    }
}

