/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.spline.base;

import java.io.Serializable;
import ru.sscc.util.CalculatingException;
import ru.sscc.util.data.DoubleVector;
import ru.sscc.util.data.FloatVector;
import ru.sscc.util.data.RealMath;
import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.RealVector;

public abstract class SmoothingPreparator
implements Serializable {
    private static double accuracy = 0.1;
    public final int sourceSize;
    protected double matrixMultiple = 1.0;
    protected double weightMultiple = 0.0;
    protected RealVector weights = null;
    protected boolean solverPrepared = false;

    protected SmoothingPreparator(int n) {
        this.sourceSize = n;
    }

    public final void ensureSolverPrepared() {
        if (!this.isSolverPrepared()) {
            throw new IllegalStateException("You should prepare solver before use");
        }
    }

    public static double getAccuracy() {
        return accuracy;
    }

    public double getAlpha() {
        return this.weightMultiple < 1.0 ? this.weightMultiple : (this.matrixMultiple == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / this.matrixMultiple);
    }

    private double innerProduct(RealVector realVector, RealVector realVector2) {
        RealPointer realPointer = realVector.getPointer();
        RealPointer realPointer2 = realVector2.getPointer();
        if (this.weights == null) {
            return RealMath.innerProduct(realPointer, realPointer2, this.sourceSize);
        }
        double d = 0.0;
        int n = 0;
        while (n < this.sourceSize) {
            d += realPointer.get() / this.weights.get(n) * realPointer2.get();
            ++n;
            realPointer.next();
            realPointer2.next();
        }
        return d;
    }

    public final boolean isSolverPrepared() {
        return this.solverPrepared;
    }

    protected void prepareMultiples(double d) {
        if (d == Double.POSITIVE_INFINITY) {
            this.matrixMultiple = 0.0;
            this.weightMultiple = 1.0;
        } else {
            if (d < 0.0) {
                throw new IllegalArgumentException("Incorrect smoothing parameter");
            }
            this.matrixMultiple = d < 1.0 ? 1.0 : 1.0 / d;
            this.weightMultiple = d < 1.0 ? d : 1.0;
        }
    }

    public abstract void prepareSolver(double var1) throws CalculatingException;

    public void prepareWeights(Object object) {
        this.solverPrepared = false;
        if (object == null) {
            this.weights = null;
            return;
        }
        RealVector realVector = RealVector.by(object);
        realVector.ensureLength(this.sourceSize);
        this.weights = new FloatVector(new float[this.sourceSize]);
        int n = 0;
        while (n < this.sourceSize) {
            double d = realVector.get(n);
            if (d <= 0.0) {
                throw new IllegalArgumentException("Incorrect weight at position " + n);
            }
            this.weights.set(n, d);
            ++n;
        }
    }

    public double selectAlpha(RealVector realVector, double d, double d2, RealVector realVector2, RealVector realVector3) throws CalculatingException {
        realVector.ensureLength(this.sourceSize);
        realVector3.ensureLength(this.sourceSize);
        this.prepareSolver(Double.POSITIVE_INFINITY);
        this.solve(realVector, realVector2, realVector3);
        double d3 = Math.sqrt(this.innerProduct(realVector3, realVector3));
        if (d * (1.0 + accuracy) >= d3) {
            return Double.POSITIVE_INFINITY;
        }
        DoubleVector doubleVector = new DoubleVector(new double[this.sourceSize]);
        while (true) {
            this.prepareSolver(d2);
            this.solve(realVector, realVector2, realVector3);
            double d4 = Math.sqrt(this.innerProduct(realVector3, realVector3));
            double d5 = d4 / d;
            if (Math.abs(d5 - 1.0) <= accuracy) {
                return d2;
            }
            int n = 0;
            while (n < this.sourceSize) {
                realVector3.set(n, realVector3.get(n) / d4);
                ++n;
            }
            d4 /= d3;
            this.solve(realVector3, realVector2, doubleVector);
            double d6 = this.innerProduct(realVector3, doubleVector);
            if (d6 >= 1.0 || d6 < d4 * 0.9) {
                throw new CalculatingException("Wrong behavior of the residual");
            }
            d2 *= d5 > 1.0 ? (1.0 - d6) / (d5 - d6) : (1.0 - d4 + (1.0 - d5) * (d6 - d4) / (1.0 - d6)) / (d5 - d4);
        }
    }

    public static double setAccuracy(double d) {
        double d2 = accuracy;
        if (d > 0.0 && d < 1.0) {
            accuracy = d;
        }
        return d2;
    }

    public abstract void solve(RealVector var1, RealVector var2, RealVector var3);
}

