/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.ecuxplot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.nyet.ecuxplot.ECUxDataset;
import org.nyet.ecuxplot.Loggers;
import org.nyet.logfile.Dataset;

public class FilterDebugPanel
extends JFrame {
    private static final long serialVersionUID = 1L;
    private ECUxDataset dataset;
    private TreeMap<String, ECUxDataset> fileDatasets;
    private ArrayList<Integer> rowIndexMapping;
    private JTable dataTable;
    private DefaultTableModel tableModel;
    private JTextArea rangeAnalysisArea;
    private JLabel statusLabel;
    private JButton refreshButton;
    private JCheckBox showAllDataCheckBox;
    private JSpinner maxRowsSpinner;
    private JComboBox<String> fileSelector;
    private JLabel fileLabel;
    private JCheckBox showOnlyValidDataCheckBox;

    public FilterDebugPanel() {
        super("Filter Debug Panel");
        this.setDefaultCloseOperation(1);
        this.setSize(1200, 600);
        this.setLocationRelativeTo(null);
        this.initializeComponents();
        this.setupLayout();
    }

    private void initializeComponents() {
        Object[] columnNames = new String[]{"Time", "RPM", "\u0394 RPM", "Raw MPH", "Calc MPH", "Diff %", "\u0394 MPH", "Accel (RPM/s)", "Pedal", "Throttle", "Gear", "Filter Status", "Filter Reasons", "In Range"};
        this.tableModel = new DefaultTableModel(columnNames, 0){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.dataTable = new JTable(this.tableModel);
        this.dataTable.setAutoResizeMode(0);
        this.dataTable.setSelectionMode(2);
        this.dataTable.getActionMap().put("copy", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterDebugPanel.this.copyTableData();
            }
        });
        this.dataTable.getInputMap().put(KeyStroke.getKeyStroke("ctrl C"), "copy");
        this.dataTable.getInputMap().put(KeyStroke.getKeyStroke("meta C"), "copy");
        this.dataTable.setDefaultRenderer(Object.class, new RangeColorRenderer());
        TableColumnModel columnModel = this.dataTable.getColumnModel();
        for (Column col : Column.values()) {
            columnModel.getColumn(col.getIndex()).setPreferredWidth(col.getWidth());
        }
        this.updateVehicleSpeedHeader();
        this.hideEmptyColumns();
        this.rangeAnalysisArea = new JTextArea(8, 50);
        this.rangeAnalysisArea.setEditable(false);
        this.rangeAnalysisArea.setFont(new Font("Monospaced", 0, 12));
        this.statusLabel = new JLabel("No dataset loaded");
        this.refreshButton = new JButton("Refresh Data");
        this.showAllDataCheckBox = new JCheckBox("Show All Data Points", false);
        this.maxRowsSpinner = new JSpinner(new SpinnerNumberModel(500, 10, 1000, 10));
        this.fileSelector = new JComboBox();
        this.fileSelector.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    String filename = value.toString();
                    if (filename.length() > 30) {
                        this.setText(filename.substring(0, 15) + "..." + filename.substring(filename.length() - 12));
                    } else {
                        this.setText(filename);
                    }
                    this.setToolTipText(filename);
                }
                return this;
            }
        });
        this.showOnlyValidDataCheckBox = new JCheckBox("Show Only Valid Data", false);
        this.fileLabel = new JLabel("File:");
        this.refreshButton.addActionListener(e -> this.refreshData());
        this.showAllDataCheckBox.addActionListener(e -> this.refreshData());
        this.maxRowsSpinner.addChangeListener(e -> this.refreshData());
        this.fileSelector.addActionListener(e -> this.onFileSelectionChanged());
        this.showOnlyValidDataCheckBox.addActionListener(e -> {
            this.updateColumnVisibility();
            this.refreshData();
        });
    }

    private void setupLayout() {
        this.setLayout(new BorderLayout());
        JPanel controlPanel = new JPanel(new BorderLayout());
        JPanel topRow = new JPanel(new FlowLayout(0));
        topRow.add(this.fileLabel);
        topRow.add(this.fileSelector);
        topRow.add(this.statusLabel);
        JPanel bottomRow = new JPanel(new FlowLayout(0));
        bottomRow.add(this.showOnlyValidDataCheckBox);
        bottomRow.add(this.showAllDataCheckBox);
        bottomRow.add(new JLabel("Max Rows:"));
        bottomRow.add(this.maxRowsSpinner);
        bottomRow.add(this.refreshButton);
        controlPanel.add((Component)topRow, "North");
        controlPanel.add((Component)bottomRow, "South");
        JPanel contentPanel = new JPanel(new BorderLayout());
        JScrollPane tableScrollPane = new JScrollPane(this.dataTable);
        tableScrollPane.setPreferredSize(new Dimension(800, 300));
        JPanel rangePanel = new JPanel(new BorderLayout());
        rangePanel.setBorder(BorderFactory.createTitledBorder("Range Analysis"));
        rangePanel.add((Component)new JScrollPane(this.rangeAnalysisArea), "Center");
        JSplitPane splitPane = new JSplitPane(0, tableScrollPane, rangePanel);
        splitPane.setDividerLocation(300);
        splitPane.setResizeWeight(0.6);
        contentPanel.add((Component)splitPane, "Center");
        this.add((Component)controlPanel, "North");
        this.add((Component)contentPanel, "Center");
    }

    public void setDataset(ECUxDataset dataset) {
        this.dataset = dataset;
        if (dataset != null) {
            boolean hasZboost;
            boolean hasRawVehicleSpeed;
            boolean hasDerivedMph = dataset.get((Comparable<?>)((Object)"VehicleSpeed (MPH)")) != null;
            boolean hasRpm = dataset.get((Comparable<?>)((Object)"RPM")) != null;
            boolean hasPedal = dataset.get((Comparable<?>[])Loggers.pedalnames) != null;
            boolean hasThrottle = dataset.get((Comparable<?>[])Loggers.throttlenames) != null;
            boolean hasGear = dataset.get((Comparable<?>[])Loggers.gearnames) != null;
            boolean hasAcceleration = dataset.get((Comparable<?>)((Object)"Acceleration (RPM/s)")) != null;
            StringBuilder statusBuilder = new StringBuilder();
            statusBuilder.append("Filter: ").append(dataset.getFilter().enabled() ? "Enabled" : "Disabled");
            boolean bl = hasRawVehicleSpeed = dataset.get((Comparable<?>)((Object)"VehicleSpeed")) != null;
            if (hasRawVehicleSpeed && hasRpm) {
                Dataset.Column rawMphCol = dataset.get((Comparable<?>)((Object)"VehicleSpeed (MPH)"));
                if (rawMphCol != null && rawMphCol.data.size() > 0) {
                    double rawMph = rawMphCol.data.get(0);
                    double calcMph = dataset.get("RPM").data.get(0) / dataset.getEnv().c.rpm_per_mph();
                    double diffPercent = (calcMph - rawMph) / rawMph * 100.0;
                    statusBuilder.append(String.format(" | VehicleSpeed: Raw=%.1f mph, Calc=%.1f mph, Diff=%+.1f%%", rawMph, calcMph, diffPercent));
                } else {
                    statusBuilder.append(" | VehicleSpeed: Raw+Calc Available");
                }
            } else if (hasRawVehicleSpeed) {
                statusBuilder.append(" | VehicleSpeed: Raw Data Only");
            } else if (hasDerivedMph) {
                statusBuilder.append(" | VehicleSpeed: Derived from RPM");
            } else if (hasRpm) {
                statusBuilder.append(" | VehicleSpeed: Calculated from RPM");
            } else {
                statusBuilder.append(" | VehicleSpeed: Not Available");
            }
            if (!hasRpm) {
                statusBuilder.append(" | No RPM");
            }
            if (!hasPedal) {
                statusBuilder.append(" | No Pedal");
            }
            if (!hasThrottle) {
                statusBuilder.append(" | No Throttle");
            }
            if (!hasGear) {
                statusBuilder.append(" | No Gear");
            }
            if (!hasAcceleration) {
                statusBuilder.append(" | No Acceleration");
            }
            boolean bl2 = hasZboost = dataset.get((Comparable<?>)((Object)"Zeitronix Boost")) != null;
            if (hasZboost) {
                statusBuilder.append(" | Zeitronix Boost");
            }
            String statusText = statusBuilder.toString();
            String currentText = this.statusLabel.getText();
            if (!currentText.startsWith("File:")) {
                this.statusLabel.setText(statusText);
            } else {
                this.statusLabel.setText(currentText.replaceAll("\\| Filter:.*", "| " + statusText.substring(statusText.indexOf("Filter:"))));
            }
        } else {
            this.statusLabel.setText("No dataset loaded");
        }
        this.updateVehicleSpeedHeader();
        this.hideEmptyColumns();
        this.updateColumnVisibility();
        this.refreshData();
    }

    public void setDatasets(TreeMap<String, ECUxDataset> fileDatasets) {
        this.fileDatasets = fileDatasets;
        this.fileSelector.removeAllItems();
        if (fileDatasets != null && !fileDatasets.isEmpty()) {
            if (fileDatasets.size() == 1) {
                String singleFile = fileDatasets.keySet().iterator().next();
                this.fileSelector.setVisible(false);
                this.fileLabel.setVisible(false);
                this.statusLabel.setText("File: " + singleFile + " | " + this.statusLabel.getText());
            } else {
                this.fileSelector.setVisible(true);
                this.fileLabel.setVisible(true);
                for (String filename : fileDatasets.keySet()) {
                    this.fileSelector.addItem(filename);
                }
                this.fileSelector.setSelectedIndex(0);
            }
            this.onFileSelectionChanged();
        } else {
            this.fileSelector.setVisible(false);
            this.fileLabel.setVisible(false);
            this.statusLabel.setText("No datasets loaded");
            this.updateVehicleSpeedHeader();
            this.updateColumnVisibility();
            this.refreshData();
        }
    }

    private void onFileSelectionChanged() {
        if (this.fileDatasets != null && !this.fileDatasets.isEmpty()) {
            if (this.fileDatasets.size() == 1) {
                String singleFile = this.fileDatasets.keySet().iterator().next();
                ECUxDataset selectedDataset = this.fileDatasets.get(singleFile);
                this.setDataset(selectedDataset);
            } else if (this.fileSelector.getSelectedItem() != null) {
                String selectedFile = (String)this.fileSelector.getSelectedItem();
                ECUxDataset selectedDataset = this.fileDatasets.get(selectedFile);
                this.setDataset(selectedDataset);
            }
        }
    }

    private void updateVehicleSpeedHeader() {
        if (this.dataset != null && this.dataTable != null) {
            TableColumnModel columnModel = this.dataTable.getColumnModel();
            TableColumn rawMphColumn = columnModel.getColumn(Column.idx(Column.RAW_MPH));
            rawMphColumn.setHeaderValue("Raw MPH");
            TableColumn calcMphColumn = columnModel.getColumn(Column.idx(Column.CALC_MPH));
            calcMphColumn.setHeaderValue("Calc MPH");
            this.dataTable.getTableHeader().repaint();
        }
    }

    private void updateColumnVisibility() {
        if (this.dataTable != null) {
            TableColumnModel columnModel = this.dataTable.getColumnModel();
            TableColumn filterReasonsColumn = columnModel.getColumn(Column.idx(Column.FILTER_REASONS));
            boolean showOnlyValid = this.showOnlyValidDataCheckBox.isSelected();
            filterReasonsColumn.setMinWidth(showOnlyValid ? 0 : 200);
            filterReasonsColumn.setMaxWidth(showOnlyValid ? 0 : Integer.MAX_VALUE);
            filterReasonsColumn.setPreferredWidth(showOnlyValid ? 0 : 200);
            filterReasonsColumn.setResizable(!showOnlyValid);
            this.dataTable.getTableHeader().repaint();
        }
    }

    private void hideEmptyColumns() {
        if (this.dataset == null || this.dataTable == null) {
            return;
        }
        TableColumnModel columnModel = this.dataTable.getColumnModel();
        boolean[] columnHasData = new boolean[Column.getColumnCount()];
        columnHasData[Column.idx((Column)Column.TIME)] = true;
        columnHasData[Column.idx((Column)Column.RPM)] = this.dataset.get((Comparable<?>)((Object)"RPM")) != null;
        columnHasData[Column.idx((Column)Column.DELTA_RPM)] = columnHasData[Column.idx(Column.RPM)];
        boolean hasRawVehicleSpeed = false;
        if (this.fileDatasets != null) {
            for (ECUxDataset ds : this.fileDatasets.values()) {
                if (ds.get((Comparable<?>)((Object)"VehicleSpeed")) == null) continue;
                hasRawVehicleSpeed = true;
                break;
            }
        }
        columnHasData[Column.idx((Column)Column.RAW_MPH)] = hasRawVehicleSpeed;
        columnHasData[Column.idx((Column)Column.CALC_MPH)] = hasRawVehicleSpeed;
        columnHasData[Column.idx((Column)Column.MPH_DIFF_PERCENT)] = hasRawVehicleSpeed;
        columnHasData[Column.idx((Column)Column.DELTA_MPH)] = hasRawVehicleSpeed;
        columnHasData[Column.idx((Column)Column.ACCELERATION)] = this.dataset.get((Comparable<?>)((Object)"Acceleration (RPM/s)")) != null;
        columnHasData[Column.idx((Column)Column.PEDAL)] = this.dataset.get((Comparable<?>[])Loggers.pedalnames) != null;
        columnHasData[Column.idx((Column)Column.THROTTLE)] = this.dataset.get((Comparable<?>[])Loggers.throttlenames) != null;
        columnHasData[Column.idx((Column)Column.GEAR)] = this.dataset.get((Comparable<?>[])Loggers.gearnames) != null;
        columnHasData[Column.idx((Column)Column.FILTER_STATUS)] = true;
        columnHasData[Column.idx((Column)Column.FILTER_REASONS)] = true;
        columnHasData[Column.idx((Column)Column.IN_RANGE)] = true;
        block1: for (int i = 0; i < columnHasData.length; ++i) {
            TableColumn column;
            if (!columnHasData[i]) {
                column = columnModel.getColumn(i);
                column.setMinWidth(0);
                column.setMaxWidth(0);
                column.setPreferredWidth(0);
                column.setResizable(false);
                continue;
            }
            column = columnModel.getColumn(i);
            column.setResizable(true);
            for (Column col : Column.values()) {
                if (col.getIndex() != i) continue;
                column.setPreferredWidth(col.getWidth());
                continue block1;
            }
        }
        this.dataTable.getTableHeader().repaint();
    }

    private void refreshData() {
        if (this.dataset == null) {
            this.tableModel.setRowCount(0);
            this.rangeAnalysisArea.setText("No dataset loaded");
            return;
        }
        this.tableModel.setRowCount(0);
        int maxRows = (Integer)this.maxRowsSpinner.getValue();
        boolean showAll = this.showAllDataCheckBox.isSelected();
        boolean showOnlyValid = this.showOnlyValidDataCheckBox.isSelected();
        Dataset.Column timeCol = this.dataset.get((Comparable<?>)((Object)"TIME"));
        Dataset.Column rpmCol = this.dataset.get((Comparable<?>)((Object)"RPM"));
        Dataset.Column mphCol = this.dataset.get((Comparable<?>)((Object)"VehicleSpeed (MPH)"));
        if (mphCol == null) {
            mphCol = this.dataset.get((Comparable<?>)((Object)"VehicleSpeed"));
        }
        Dataset.Column pedalCol = this.dataset.get((Comparable<?>[])Loggers.pedalnames);
        Dataset.Column throttleCol = this.dataset.get((Comparable<?>[])Loggers.throttlenames);
        Dataset.Column gearCol = this.dataset.get((Comparable<?>[])Loggers.gearnames);
        if (timeCol == null || timeCol.data.size() == 0) {
            this.rangeAnalysisArea.setText("No TIME data available");
            return;
        }
        int totalRows = timeCol.data.size();
        int rowsToShow = showAll ? totalRows : Math.min(maxRows, totalRows);
        ArrayList<Dataset.Range> ranges = this.dataset.getRanges();
        this.rowIndexMapping = new ArrayList();
        int rowsAdded = 0;
        for (int i = 0; !(i >= rowsToShow || showOnlyValid && rowsAdded >= maxRows); ++i) {
            if (showOnlyValid) {
                boolean inRange = false;
                for (Dataset.Range range : ranges) {
                    if (i < range.start || i > range.end) continue;
                    inRange = true;
                    break;
                }
                if (!inRange) continue;
            }
            Object[] row = new Object[Column.getColumnCount()];
            row[Column.idx((Column)Column.TIME)] = String.format("%.2f", timeCol.data.get(i));
            row[Column.idx((Column)Column.RPM)] = rpmCol != null && i < rpmCol.data.size() ? String.format("%.0f", rpmCol.data.get(i)) : "N/A";
            Dataset.Column rawMphCol = this.dataset.get((Comparable<?>)((Object)"VehicleSpeed (MPH)"));
            row[Column.idx((Column)Column.RAW_MPH)] = rawMphCol != null && i < rawMphCol.data.size() ? String.format("%.2f", rawMphCol.data.get(i)) : "N/A";
            if (rpmCol != null && i < rpmCol.data.size()) {
                double calcMph = rpmCol.data.get(i) / this.dataset.getEnv().c.rpm_per_mph();
                row[Column.idx((Column)Column.CALC_MPH)] = String.format("%.2f", calcMph);
            } else {
                row[Column.idx((Column)Column.CALC_MPH)] = "N/A";
            }
            if (rawMphCol != null && rpmCol != null && i < rawMphCol.data.size() && i < rpmCol.data.size()) {
                double rawMph = rawMphCol.data.get(i);
                double calcMph = rpmCol.data.get(i) / this.dataset.getEnv().c.rpm_per_mph();
                if (calcMph > 0.0) {
                    double diffPercent = (calcMph - rawMph) / rawMph * 100.0;
                    row[Column.idx((Column)Column.MPH_DIFF_PERCENT)] = String.format("%+.1f%%", diffPercent);
                } else {
                    row[Column.idx((Column)Column.MPH_DIFF_PERCENT)] = "N/A";
                }
            } else {
                row[Column.idx((Column)Column.MPH_DIFF_PERCENT)] = "N/A";
            }
            if (i > 0 && rpmCol != null && i < rpmCol.data.size() && i - 1 < rpmCol.data.size()) {
                double currentRPM = rpmCol.data.get(i);
                double prevRPM = rpmCol.data.get(i - 1);
                double deltaRPM = currentRPM - prevRPM;
                row[Column.idx((Column)Column.DELTA_RPM)] = String.format("%+.0f", deltaRPM);
            } else {
                row[Column.idx((Column)Column.DELTA_RPM)] = "N/A";
            }
            if (i > 0) {
                double currentMPH = 0.0;
                double prevMPH = 0.0;
                boolean hasData = false;
                if (rawMphCol != null && i < rawMphCol.data.size() && i - 1 < rawMphCol.data.size()) {
                    currentMPH = rawMphCol.data.get(i);
                    prevMPH = rawMphCol.data.get(i - 1);
                    hasData = true;
                } else if (rpmCol != null && i < rpmCol.data.size() && i - 1 < rpmCol.data.size()) {
                    currentMPH = rpmCol.data.get(i) / this.dataset.getEnv().c.rpm_per_mph();
                    prevMPH = rpmCol.data.get(i - 1) / this.dataset.getEnv().c.rpm_per_mph();
                    hasData = true;
                }
                if (hasData) {
                    double deltaMPH = currentMPH - prevMPH;
                    row[Column.idx((Column)Column.DELTA_MPH)] = String.format("%+.2f", deltaMPH);
                } else {
                    row[Column.idx((Column)Column.DELTA_MPH)] = "N/A";
                }
            } else {
                row[Column.idx((Column)Column.DELTA_MPH)] = "N/A";
            }
            Dataset.Column accelCol = this.dataset.get((Comparable<?>)((Object)"Acceleration (RPM/s)"));
            row[Column.idx((Column)Column.ACCELERATION)] = accelCol != null && i < accelCol.data.size() ? String.format("%.1f", accelCol.data.get(i)) : "N/A";
            row[Column.idx((Column)Column.PEDAL)] = pedalCol != null && i < pedalCol.data.size() ? String.format("%.1f", pedalCol.data.get(i)) : "N/A";
            row[Column.idx((Column)Column.THROTTLE)] = throttleCol != null && i < throttleCol.data.size() ? String.format("%.1f", throttleCol.data.get(i)) : "N/A";
            row[Column.idx((Column)Column.GEAR)] = gearCol != null && i < gearCol.data.size() ? String.format("%.0f", gearCol.data.get(i)) : "N/A";
            if (this.dataset.getFilter().enabled()) {
                boolean isValid = this.dataset.dataValid(i);
                Object object = row[Column.idx((Column)Column.FILTER_STATUS)] = isValid ? "\u2713 Valid" : "\u2717 Rejected";
                row[Column.idx((Column)Column.FILTER_REASONS)] = !isValid && this.dataset.getLastFilterReasons() != null ? String.join((CharSequence)", ", this.dataset.getLastFilterReasons()) : "";
            } else {
                row[Column.idx((Column)Column.FILTER_STATUS)] = "Filter Disabled";
                row[Column.idx((Column)Column.FILTER_REASONS)] = "";
            }
            int rangeNumber = -1;
            for (int r = 0; r < ranges.size(); ++r) {
                Dataset.Range range = ranges.get(r);
                if (i < range.start || i > range.end) continue;
                rangeNumber = r + 1;
                break;
            }
            row[Column.idx((Column)Column.IN_RANGE)] = rangeNumber > 0 ? "Range " + rangeNumber : "None";
            this.tableModel.addRow(row);
            this.rowIndexMapping.add(i);
            ++rowsAdded;
        }
        this.updateRangeAnalysis();
    }

    private void updateRangeAnalysis() {
        if (this.dataset == null) {
            this.rangeAnalysisArea.setText("No dataset loaded");
            return;
        }
        StringBuilder analysis = new StringBuilder();
        analysis.append("FILTER STATUS:\n");
        analysis.append("  Enabled: ").append(this.dataset.getFilter().enabled()).append("\n");
        if (this.dataset.getFilter().enabled()) {
            analysis.append("  Min RPM: ").append(this.dataset.getFilter().minRPM()).append("\n");
            analysis.append("  Max RPM: ").append(this.dataset.getFilter().maxRPM()).append("\n");
            analysis.append("  Min RPM Range: ").append(this.dataset.getFilter().minRPMRange()).append("\n");
            analysis.append("  Min Pedal: ").append(this.dataset.getFilter().minPedal()).append("\n");
            analysis.append("  Min Throttle: ").append(this.dataset.getFilter().minThrottle()).append("\n");
            analysis.append("  Gear Filter: ").append(this.dataset.getFilter().gear()).append("\n");
            analysis.append("  Min Points: ").append(this.dataset.getFilter().minPoints()).append("\n");
            analysis.append("  Monotonic RPM: ").append(this.dataset.getFilter().monotonicRPM()).append("\n");
            analysis.append("  Monotonic RPM Fuzz: ").append(this.dataset.getFilter().monotonicRPMfuzz()).append("\n");
        }
        analysis.append("\n");
        ArrayList<Dataset.Range> ranges = this.dataset.getRanges();
        analysis.append("RANGE ANALYSIS:\n");
        analysis.append("  Total Ranges Found: ").append(ranges.size()).append("\n");
        if (ranges.size() > 0) {
            analysis.append("\n  Range Details:\n");
            for (int i = 0; i < ranges.size(); ++i) {
                Dataset.Column timeCol;
                Dataset.Range range = ranges.get(i);
                analysis.append("    Range ").append(i + 1).append(": ").append(range.toString()).append(" (").append(range.size()).append(" points)\n");
                Dataset.Column rpmCol = this.dataset.get((Comparable<?>)((Object)"RPM"));
                if (rpmCol != null && range.start < rpmCol.data.size() && range.end < rpmCol.data.size()) {
                    double startRPM = rpmCol.data.get(range.start);
                    double endRPM = rpmCol.data.get(range.end);
                    analysis.append("      RPM Range: ").append(String.format("%.0f", startRPM)).append(" - ").append(String.format("%.0f", endRPM)).append(" (\u0394").append(String.format("%.0f", endRPM - startRPM)).append(")\n");
                }
                if ((timeCol = this.dataset.get((Comparable<?>)((Object)"TIME"))) == null || range.start >= timeCol.data.size() || range.end >= timeCol.data.size()) continue;
                double startTime = timeCol.data.get(range.start);
                double endTime = timeCol.data.get(range.end);
                analysis.append("      Time Range: ").append(String.format("%.2f", startTime)).append(" - ").append(String.format("%.2f", endTime)).append(" (\u0394").append(String.format("%.2f", endTime - startTime)).append("s)\n");
            }
        } else {
            analysis.append("  No valid ranges found!\n");
            analysis.append("  Check filter settings or data quality.\n");
        }
        this.rangeAnalysisArea.setText(analysis.toString());
    }

    public void showWindow() {
        this.setVisible(true);
        this.toFront();
    }

    private void copyTableData() {
        int[] selectedRows = this.dataTable.getSelectedRows();
        int[] selectedCols = this.dataTable.getSelectedColumns();
        if (selectedRows.length == 0 || selectedCols.length == 0) {
            return;
        }
        StringBuilder clipboardData = new StringBuilder();
        for (int col : selectedCols) {
            String columnName = this.dataTable.getColumnModel().getColumn(col).getHeaderValue().toString();
            clipboardData.append(columnName);
            if (col >= selectedCols.length - 1) continue;
            clipboardData.append("\t");
        }
        clipboardData.append("\n");
        for (int row : selectedRows) {
            for (int col : selectedCols) {
                Object value = this.dataTable.getValueAt(row, col);
                clipboardData.append(value != null ? value.toString() : "");
                if (col >= selectedCols.length - 1) continue;
                clipboardData.append("\t");
            }
            clipboardData.append("\n");
        }
        StringSelection selection = new StringSelection(clipboardData.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, null);
    }

    private class RangeColorRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private final Color[] rangeColors = new Color[]{new Color(240, 248, 255), new Color(255, 248, 240), new Color(240, 255, 240), new Color(255, 240, 255), new Color(248, 248, 255), new Color(255, 255, 240), new Color(240, 255, 255), new Color(255, 240, 240)};

        private RangeColorRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            RangeInfo rangeInfo;
            int actualRowIndex;
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (isSelected) {
                return this;
            }
            if (FilterDebugPanel.this.dataset != null && (actualRowIndex = this.getActualRowIndex(row)) >= 0 && (rangeInfo = this.getRangeInfo(actualRowIndex)) != null) {
                int colorIndex = rangeInfo.rangeNumber % this.rangeColors.length;
                this.setBackground(this.rangeColors[colorIndex]);
                if (rangeInfo.isStart || rangeInfo.isEnd) {
                    this.setFont(this.getFont().deriveFont(1));
                } else {
                    this.setFont(this.getFont().deriveFont(0));
                }
                return this;
            }
            this.setBackground(Color.WHITE);
            this.setFont(this.getFont().deriveFont(0));
            return this;
        }

        private int getActualRowIndex(int tableRow) {
            if (FilterDebugPanel.this.rowIndexMapping != null && tableRow < FilterDebugPanel.this.rowIndexMapping.size()) {
                return FilterDebugPanel.this.rowIndexMapping.get(tableRow);
            }
            return tableRow;
        }

        private RangeInfo getRangeInfo(int rowIndex) {
            if (FilterDebugPanel.this.dataset == null) {
                return null;
            }
            ArrayList<Dataset.Range> ranges = FilterDebugPanel.this.dataset.getRanges();
            for (int i = 0; i < ranges.size(); ++i) {
                Dataset.Range range = ranges.get(i);
                if (rowIndex < range.start || rowIndex > range.end) continue;
                boolean isStart = rowIndex == range.start;
                boolean isEnd = rowIndex == range.end;
                return new RangeInfo(i + 1, isStart, isEnd);
            }
            return null;
        }
    }

    private static enum Column {
        TIME(0, 80),
        RPM(1, 60),
        DELTA_RPM(2, 70),
        RAW_MPH(3, 80),
        CALC_MPH(4, 80),
        MPH_DIFF_PERCENT(5, 70),
        DELTA_MPH(6, 70),
        ACCELERATION(7, 100),
        PEDAL(8, 60),
        THROTTLE(9, 70),
        GEAR(10, 50),
        FILTER_STATUS(11, 80),
        FILTER_REASONS(12, 200),
        IN_RANGE(13, 70);

        private final int index;
        private final int width;

        private Column(int index, int width) {
            this.index = index;
            this.width = width;
        }

        public int getIndex() {
            return this.index;
        }

        public int getWidth() {
            return this.width;
        }

        public static int getColumnCount() {
            return Column.values().length;
        }

        public static int idx(Column col) {
            return col.getIndex();
        }
    }

    private static class RangeInfo {
        final int rangeNumber;
        final boolean isStart;
        final boolean isEnd;

        RangeInfo(int rangeNumber, boolean isStart, boolean isEnd) {
            this.rangeNumber = rangeNumber;
            this.isStart = isStart;
            this.isEnd = isEnd;
        }
    }
}

